<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * CompanyEmployee
 *
 * @ORM\Table(name="company_employees")
 * @ORM\Entity(repositoryClass="VM\ApiBundle\Repository\CompanyEmployeeRepository")
 *
 * @ExclusionPolicy("all")
 */
class CompanyEmployee
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails", "employeesDetails"})
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="company_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({})
     */
    private $companyId;

    /**
     * @var integer
     *
     * @ORM\Column(name="employee_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    private $employeeId;

    /**
     * @var integer
     *
     * @ORM\Column(name="department_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"employeesDetails","companyDetails"})
     */
    private $departmentId;

    /**
     * @ORM\ManyToOne(targetEntity="Company",inversedBy="companyEmployees")
     * @ORM\JoinColumn(name="company_id", referencedColumnName="id")
     */
    private $company;

    /**
     * @ORM\ManyToOne(targetEntity="Employee",inversedBy="companyEmployees")
     * @ORM\JoinColumn(name="employee_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails", "employeesDetails"})
     */
    private $employee;

    /**
     * @ORM\ManyToOne(targetEntity="Department",inversedBy="companyEmployees")
     * @ORM\JoinColumn(name="department_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    private $department;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set companyId
     *
     * @param integer $companyId
     * @return CompanyEmployee
     */
    public function setCompanyId($companyId)
    {
        $this->companyId = $companyId;
    
        return $this;
    }

    /**
     * Get companyId
     *
     * @return integer 
     */
    public function getCompanyId()
    {
        return $this->companyId;
    }

    /**
     * Set employeeId
     *
     * @param integer $employeeId
     * @return CompanyEmployee
     */
    public function setEmployeeId($employeeId)
    {
        $this->employeeId = $employeeId;
    
        return $this;
    }

    /**
     * Get employeeId
     *
     * @return integer 
     */
    public function getEmployeeId()
    {
        return $this->employeeId;
    }

    /**
     * Set departmentId
     *
     * @param integer $departmentId
     * @return CompanyEmployee
     */
    public function setDepartmentId($departmentId)
    {
        $this->departmentId = $departmentId;
    
        return $this;
    }

    /**
     * Get departmentId
     *
     * @return integer 
     */
    public function getDepartmentId()
    {
        return $this->departmentId;
    }

    /**
     * Set company
     *
     * @param \VM\ApiBundle\Entity\Company $company
     * @return CompanyEmployee
     */
    public function setCompany(\VM\ApiBundle\Entity\Company $company = null)
    {
        $this->company = $company;
    
        return $this;
    }

    /**
     * Get company
     *
     * @return \VM\ApiBundle\Entity\Company 
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Set employee
     *
     * @param \VM\ApiBundle\Entity\Employee $employee
     * @return CompanyEmployee
     */
    public function setEmployee(\VM\ApiBundle\Entity\Employee $employee = null)
    {
        $this->employee = $employee;
    
        return $this;
    }

    /**
     * Get employee
     *
     * @return \VM\ApiBundle\Entity\Employee 
     */
    public function getEmployee()
    {
        return $this->employee;
    }

    /**
     * Set department
     *
     * @param \VM\ApiBundle\Entity\Department $department
     * @return CompanyEmployee
     */
    public function setDepartment(\VM\ApiBundle\Entity\Department $department = null)
    {
        $this->department = $department;
    
        return $this;
    }

    /**
     * Get department
     *
     * @return \VM\ApiBundle\Entity\Department 
     */
    public function getDepartment()
    {
        return $this->department;
    }
}